/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.j2ee.Integration.ServiceActivator;
import javax.jms.*;
import javax.naming.*;

public class ServiceActivator implements javax.jms.MessageListener {
	public ServiceActivator(String connFactoryName, String queueName) {
		super();
		this.connFactoryName = connFactoryName;
		this.queueName = queueName;
		startListener();

		/* Comment by Together
		
			*/
	}

	private void startListener() {
		try {
			Context ctx = new InitialContext();
			// Looks up the connection factory object
			QueueConnectionFactory qConnFactory =
				(QueueConnectionFactory) ctx.lookup(connFactoryName);
			QueueConnection qConn = qConnFactory.createQueueConnection();
			// See JMS API for method usage and arguments
			orderQueueSession =
				qConn.createQueueSession(true, Session.AUTO_ACKNOWLEDGE);
			// Looks up the queue object
			Queue ordersQueue = (Queue) ctx.lookup(queueName);
			orderQueueReceiver = orderQueueSession.createReceiver(ordersQueue);
			orderQueueReceiver.setMessageListener(this);
		} catch (Exception ex) {
			// handle error
		}
	}

	public void onMessage(Message msg) {
		try {
			// parse Message msg. See JMS API for Message.
			//
			// Write your code here
			//
			// send any acknowledgement here...
			//
			// Write your code here
			//
		} catch (Exception excp) {
			// Handle any other exceptions
		}
	}

	public void close() {
		try {
			// cleanup before closing
			orderQueueReceiver.setMessageListener(null);
			orderQueueSession.close();
		} catch (Exception excp) {
			// Handle exception - Failure to close
		}
	}

	public String getServiceActivatorInfo() {
		return "Service Activator description";
	}

	private QueueSession orderQueueSession;
	public QueueReceiver orderQueueReceiver;
	private String connFactoryName;
	private String queueName;
}

