/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.j2ee.Business.ValueListHandler.ValueListAsSession;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.CreateException;
import java.util.List;
import java.util.ListIterator;
import java.util.LinkedList;
import java.util.Collection;

/**
 * @ejbHome <{Session1Home}>
 * @ejbRemote <{Session1}>
 */
public class Session1Bean implements SessionBean, ValueListIterator {
	private SessionContext ctx;
	protected List list;
	protected ListIterator listIterator;

	/**
	 * @link
	 * @shapeType PatternLink
	 * @hidden
	 */
	/*# private IteratorException _iteratorException; */

	public void setSessionContext(SessionContext context)
		throws RemoteException, EJBException {
		ctx = context;
	}

	public void ejbActivate() throws EJBException {
	}

	public void ejbPassivate() throws EJBException {
	}

	public void ejbRemove() throws EJBException {
	}

	public void ejbCreate() throws CreateException, EJBException {
		// Write your code here
	}

	public void setList(List list) throws IteratorException {
		this.list = list;
		if (list != null) {
			listIterator = list.listIterator();
		} else {
			throw new IteratorException("List empty");
		}
	}

	public Collection getList() {
		return list;
	}

	public int getSize() throws IteratorException {
		int size = 0;
		if (list != null) {
			size = list.size();
		} else {
			throw new IteratorException("List empty");
		}
		return size;
	}

	public Object getCurrentElement() throws IteratorException {
		Object obj = null;
		if (list != null) {
			int currIndex = listIterator.nextIndex();
			obj = list.get(currIndex);
		} else {
			throw new IteratorException();
		}
		return obj;
	}

	public List getPreviousElements(int count) throws IteratorException {
		int i = 0;
		Object object = null;
		LinkedList list = new LinkedList();
		if (listIterator != null) {
			while (listIterator.hasPrevious() && (i < count)) {
				object = listIterator.previous();
				list.add(object);
				i++;
			}
		} else {
			throw new IteratorException();
		}
		return list;
	}

	public List getNextElements(int count) throws IteratorException {
		int i = 0;
		Object object = null;
		LinkedList list = new LinkedList();
		if (listIterator != null) {
			while (listIterator.hasNext() && (i < count)) {
				object = listIterator.next();
				list.add(object);
				i++;
			}
		} else {
			throw new IteratorException();
		}
		return list;
	}

	public void resetIndex() throws IteratorException {
		if (listIterator != null) {
			listIterator = list.listIterator();
		} else {
			throw new IteratorException();
		}
	}
}

