/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.j2ee.Business.CompositeEntity.ValueObjectStrategy;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.EJBException;
import javax.ejb.CreateException;
import java.sql.SQLException;

/**
 * @ejbHome <{Entity1Home}>
 * @ejbRemote <{Entity1}>
 * @ejbPrimaryKey <{Entity1PK}>
 */
public class Entity1Bean implements EntityBean {
	private EntityContext ctx;
	public int field1;
	private DependentObject fieldDependentObject;

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Composite Value Object Strategy
	 * @supplierRole CompositeValueObject
	 */

	/*# private DependentObject _dependentObject; */

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Updatable Value Objects Strategy
	 * @supplierRole UpdatableValueObjectsStrategyLink
	 */

	/*# private Entity1BeanVO _entity1BeanVO; */

	public void setEntityContext(EntityContext context) throws EJBException {
		ctx = context;
	}

	public void unsetEntityContext() throws EJBException {
		ctx = null;
	}

	public void ejbActivate() throws EJBException {
	}

	public void ejbPassivate() throws EJBException {
	}

	public void ejbRemove() throws EJBException {
	}

	public void ejbStore() throws EJBException {
	}

	public void ejbLoad() throws EJBException {
	}

	public Entity1PK ejbCreate()
		throws CreateException, EJBException, SQLException {
		// Write your code here
		return null;
	}

	public void ejbPostCreate()
		throws CreateException, EJBException, SQLException {
		// Write your code here
	}

	public int getField1() {
		return field1;
	}

	public void setField1(int param) {
		this.field1 = param;
	}

	public DependentObject getFieldDependentObject() {
		return fieldDependentObject;
	}

	public void setFieldDependentObject(DependentObject fieldDependentObject) {
		this.fieldDependentObject = fieldDependentObject;
	}

	private Entity1BeanVO createEntity1BeanVO() {
		Entity1BeanVO valueObj = new Entity1BeanVO();
		valueObj.field1 = field1;
		return valueObj;
	}

	public Entity1BeanVO getEntity1BeanVO() {
		return createEntity1BeanVO();
	}

	private void mergeEntity1BeanVO(Entity1BeanVO valueObj) {
		field1 = valueObj.field1;
	}

	public void setEntity1BeanVO(Entity1BeanVO param) {
		mergeEntity1BeanVO(param);
	}
}

