/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.j2ee.Business.BusinessDelegate.DelegateProxyStrategy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;

import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class ServiceLocator {
	private ServiceLocator() throws ServiceLocatorException {
		try {
			context = new InitialContext();
		} catch (NamingException ne) {
			throw new ServiceLocatorException(ne);
		}
	}

	public static ServiceLocator getInstance() throws ServiceLocatorException {
		if (myServiceLocator == null) {
			myServiceLocator = new ServiceLocator();
		}
		return myServiceLocator;
	}

	public static EJBObject getService(String id)
		throws ServiceLocatorException {
		if (id == null) {
			return null;
		}
		try {
			byte[] bytes = new String(id).getBytes();
			InputStream io = new ByteArrayInputStream(bytes);
			ObjectInputStream os = new ObjectInputStream(io);
			javax.ejb.Handle handle = (javax.ejb.Handle) os.readObject();
			return handle.getEJBObject();
		} catch (Exception ex) {
			throw new ServiceLocatorException(ex);
		}
	}

	public static String getId(EJBObject session)
		throws ServiceLocatorException {
		try {
			javax.ejb.Handle handle = session.getHandle();
			ByteArrayOutputStream fo = new ByteArrayOutputStream();
			ObjectOutputStream so = new ObjectOutputStream(fo);
			so.writeObject(handle);
			so.flush();
			so.close();
			return new String(fo.toByteArray());
		} catch (RemoteException ex) {
			throw new ServiceLocatorException(ex);
		} catch (IOException ex) {
			throw new ServiceLocatorException(ex);
		}
	}

	public EJBHome getHome(String name, Class clazz)
		throws ServiceLocatorException {
		try {
			Object objref = context.lookup(name);
			EJBHome home = (EJBHome) PortableRemoteObject.narrow(objref, clazz);
			return home;
		} catch (NamingException ex) {
			throw new ServiceLocatorException(ex);
		}
	}

	public String getServiceLocatorInfo() {
		return "ServiceLocator description";
	}

	private static ServiceLocator myServiceLocator;
	private InitialContext context = null;
}

