/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.j2ee.Business.BusinessDelegate.DelegateProxyStrategy;
import java.rmi.RemoteException;

import javax.ejb.CreateException;

public class BusinessDelegate {
	public void operation1() throws BusinessException {
		try {
			Session1Home home =
				(Session1Home) ServiceLocator.getInstance().getHome(
					"Session1Home",
					homeClazz);
			session = home.create();
		} catch (ServiceLocatorException ex) {
			// Translate ServiceLocatorException into
			// application exception
			throw new BusinessException();
		} catch (CreateException ex) {
			// Translate CreateException into
			// application exception
			throw new BusinessException();
		} catch (RemoteException ex) {
			// Translate RemoteException into
			// application exception
			throw new BusinessException();
		}
	}

	public void operation1(String id) throws BusinessException {
		reconnect(id);
	}

	public String getID() throws BusinessException {
		try {
			return ServiceLocator.getId(session);
		} catch (Exception e) {
			throw new BusinessException();
		}
	}

	public void reconnect(String ID) throws BusinessException {
		try {
			session = (Session1) ServiceLocator.getService(ID);
		} catch (ServiceLocatorException ex) {
			throw new BusinessException();
		}
	}

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Business Delegate Proxy Strategy
	 * @supplierRole Uses
	 */
	/*# private ServiceLocator _serviceLocator; */

	/**
	 * @link
	 * @shapeType PatternLink
	 * @pattern Business Delegate Proxy Strategy
	 * @supplierRole Uses
	 */
	/*# private BusinessException _businessException; */
	private Session1 session;
	private Class homeClazz = Session1Home.class;
}

