/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.visitor;

/**
 * Declares a Visit operation for each class of
 * ConcreteElement in the object structure.
 * The operation's name and signature identifies
 * the class that sends the Visit request to the
 * visitor. That lets the visitor determine the
 * concrete class of the element being visited.
 * Then the visitor can access the element
 * directly through its particular interface.
 * @role __Visitor
 */
public interface Visitor {
	/**
	 * Visit method for Concrete Element.
	 */
	void visitConcreteElement(ConcreteElement element);

}

