/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.templatemethod;

/**
 * This class defines abstract <b>primitive operations</b>
 * that concrete subclasses define to implement steps
 * of an algorithm. Implements a template method defining
 * the skeleton of an algorithm.
 * @role __TemplateContext
 */
public abstract class Context {
	/**
	 * Primitive operation.
	 */
	public abstract void doPrimitiveOperation();

	/**
	 * Defines the skeleton of an algorithm. Calls primitive 
	 * operations as well as operations defined in AbstractClass 
	 * or those in other objects.
	 */
	public void templateMethod() {
		// put your code here

		doPrimitiveOperation();

		// put your code here
	}

}

