/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.strategy;

/**
 * Is configured with a ConcreteStrategy object.
 * Maintains a reference to strategy object.
 * May define an interface that lets Strategy access its data.
 * @role __StrategyContext
 */
public class Context {
	private Strategy strategy;

	public Context(Strategy newStrategy) {
		this.strategy = newStrategy;
	}

	public void contextRequest() {
		strategy.someOperation();
	}

}

