/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.observer;

import java.util.Iterator;
import java.util.ArrayList;
/**
 * Knows its observers. Any number of Observer objects
 * may observe a subject. Provides an interface for attaching
 * and detaching Observer objects.
 * @role __Subject
 */
public class Subject {
	private ArrayList observers = new ArrayList();

	public void attach(Observer observer) {
		observers.add(observer);
	}

	public void detach(Observer observer) {
		int idx = observers.indexOf(observer);
		if (idx != -1) {
			observers.remove(idx);
		}
	}

	protected void notifyObservers() {
		Iterator it = observers.iterator();
		while (it.hasNext()) {
			((Observer) it.next()).update(this);
		}
	}

}

