/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.mediator;

/**
 * Each colleague knows its Mediator object.
 * Communicates with its mediator whenever it would
 * have otherwise communicated with another colleague.
 * @role __Colleague
 */
public abstract class Colleague {
	/** my mediator */
	private Mediator mediator;

	/** Create colleague which knows about supplied mediator */
	protected Colleague(Mediator mediator) {
		this.mediator = mediator;
	}

	/** @return mediator this colleague knows about */
	public Mediator getMediator() {
		return mediator;
	}

}

