/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.flyweight;


import java.util.HashMap;
/**
 * Creates and manages flyweight objects. Ensures that flyweights are shared properly.
 * When a client requests a flyweight, this factory supplies an existing instance or
 * creates one, if none exists.
 * @role __Factory
 */
public class FlyweightFactory {
	private HashMap flyweight;

	public FlyweightFactory() {
		flyweight = new HashMap();
	}


	public Flyweight getFlyweight(Object key) {
		if (flyweight.containsKey(key)) {
			return (Flyweight) flyweight.get(key);
		} else {
			Flyweight newFlyweight = new ConcreteFlyweight(key);
			flyweight.put(key, newFlyweight);
			return newFlyweight;
		}
	}


	/**
	* @return new instance ofunshared flyweight
	*/
	public Flyweight getUnsharedConcreteFlyweight() {
		return new UnsharedConcreteFlyweight();
	}


}