/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.factory_method;

/**
 * Declares the factory method, which returns an object of type Product.
 * Creator may also define a default implementation of the factory method
 * that returns a default Concrete Product object
 * may call the factory method to create a Product object.
 * @role __Creator
 */
public abstract class Creator {
	/** You can provide default implementation of this method */
	protected abstract Product factoryMethod();

	/**
	 *  This operation uses factoryMethod to create instances
	 *  of <code>Product</code>
	 **/
	public void someOperation() {
		// ...
		Product product = factoryMethod();
		// ...
	}

}

