/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.decorator;

/**
 * Maintains the reference to a Component object and defines an
 * interface that conforms to Component's interface
 * @role __Decorator
 */
public abstract class Decorator extends Component {
	/** reference to the decorated component */
	protected Component component;

	/**
	 * @param decorateMe component to decorate
	 */
	public Decorator(Component decorateMe) {
		this.component = decorateMe;
	}

	public void doSomeStuff() {
		component.doSomeStuff();
	}

}

