/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.composite;

import java.util.Iterator;
import java.util.ArrayList;
/**
 * Defines behavior for components having children. Stores child components.
 * Implements child-related operations int Component interface
 * @role __Composite
 */
public class Composite extends Component {
	/** Stores components of this composite */
	private ArrayList components;

	/** This is sample operation */
	public void someOperation() {
		Iterator it = getChildren();
		while (it.hasNext()) {
			((Component) it.next()).someOperation();
		}
	}

	/** @see Component#addChild(Component) */
	public void addChild(Composite child) {
		if (components == null) {
			components = new ArrayList();
		}
		components.add(child);
	}

	/** @see Component#removeChild(Component) */
	public void removeChild(Component child) {
		if (components != null) {
			int idx = components.indexOf(child);
			if (idx != -1) {
				components.remove(idx);
			}
		}
	}

	/** @see @{ComponentClass}#getChildren() */
	public Iterator getChildren() {
		if (components == null) {
			return null;
		}
		return components.iterator();
	}

}

