/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.composite;

import java.util.Iterator;
/**
 * Declares the interface for objects in the composition. Implements default behavior
 * for the interface common to all classes, as appropriate.
 * @role __Component
 */
public abstract class Component {
	/**
	 * Sample method
	 */
	public abstract void someOperation();

	/** Add child to Composite */
	public void addChild(Component child) {
		// default implementation - throw error
		throw new RuntimeException("addChild():Not intended to be called");
	}

	/** Remove child from Composite */
	public void removeChild(Component child) {
		// default implementation - throw error
		throw new RuntimeException("remove(): Not intended to be called");
	}

	/** 
	 *  @return iterator over children of this component, or 
	 *  <code>null</code> if there are no children.
	 */
	public Iterator getChildren() {
		return null;
	}

}

