/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.command;

/**
 * Concrete Command that executes a sequence of Commands.
 */
public class MacroCommand implements Command {
	/** Commands to execute */
	private Command[] commands;

	/** @param commands Commands to execute */
	public MacroCommand(Command[] commands) {
		this.commands = commands;
	}

	/** Executes sequence of Commands */
	public void executeCommand() {
		if (commands != null) {
			for (int i = 0; i < commands.length; i++) {
				commands[i].executeCommand();
			}
		}
	}

}

