/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.chainofresponsibility;

/**
 * Defines interface for request handling
 * @role __Handler
 */
public class Handler {
	private Handler successor;

	/** Default request handling */
	public void handleRequest() {
		if (successor != null) {
			successor.handleRequest();
		}
	}

	public Handler getSuccessor() {
		return this.successor;
	}

	public void setSuccessor(Handler successor) {
		this.successor = successor;
	}

}

