/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.bridge;

/**
 * Defines Abstraction interface. Stores reference to implementation.
 * @role __Abstraction
 */
public abstract class Abstraction {
	/** Reference to actual implementation */
	private Implementor impl;

	/**
	 * @return implementation-in-action. 
	 */
	protected Implementor getImplementor() {
		return impl;
	}

	/**
	 * This sample operation delegates call to particular implementation
	 */
	public void someOperation() {
		getImplementor().someOperationImpl();
	}

}

