/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.adapter;

/**
 * This class adapts the interface of Adaptee to the Target interface
 */
public class Adapter extends Target {
	/** reference to the object being adapted */
	private Adaptee adaptee;

	/**
	 * @param adaptMe class to adapt whis this adapter
	 */
	public Adapter(Adaptee adaptMe) {
		this.adaptee = adaptMe;
	}

	/**
	 * Implementation of target method that uses adaptee to perform task
	 */
	public void request() {
		adaptee.specificRequest();
	}

}

