/*-----------------------------------------------------------------------------------
Copyright (c)2003 Borland Software Corporation. Patents pending. All rights reserved.
-----------------------------------------------------------------------------------*/

package patterns.gof.abstract_factory;

/**
 * Concrete Factory implements operations of AbstractFactory 
 * to create Concrete product objects. 
 */
public class MyFactory implements AbstractFactory {

	/**
	 *  Creates concrete product ConcreteProduct1
	 */
	public ProductA createProductA() {
		return new ConcreteProduct1();
	}

	/**
	 *  Creates concrete product ConcreteProduct2
	 */
	public ProductB createProductB() {
		return new ConcreteProduct2();
	}

}

