/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/util/PrimitiveTypeTool.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.util;

import com.sap.tc.jtools.jlint.jom.interfaces.IBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IPrimitiveTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ISimpleType;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

/**
 * @author D037913
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class PrimitiveTypeTool {

  private PrimitiveTypeTool() {
  }

  public static boolean isInt(ITypeBinding bnd) {
    if (!(bnd instanceof IPrimitiveTypeBinding))
      return false;
    return ISimpleType.INT.equals(bnd.getName());
  }

	public static boolean isBoolean(ITypeBinding bnd) {
		if (!(bnd instanceof IPrimitiveTypeBinding))
			return false;
		return ISimpleType.BOOLEAN.equals(bnd.getName());
	}

	public static boolean isDouble(ITypeBinding bnd) {
		if (!(bnd instanceof IPrimitiveTypeBinding))
			return false;
		return ISimpleType.DOUBLE.equals(bnd.getName());
	}

	public static boolean isFloat(ITypeBinding bnd) {
		if (!(bnd instanceof IPrimitiveTypeBinding))
			return false;
		return ISimpleType.FLOAT.equals(bnd.getName());
	}

	public static boolean isLong(ITypeBinding bnd) {
		if (!(bnd instanceof IPrimitiveTypeBinding))
			return false;
		return ISimpleType.LONG.equals(bnd.getName());
	}

	public static boolean isShort(ITypeBinding bnd) {
		if (!(bnd instanceof IPrimitiveTypeBinding))
			return false;
		return ISimpleType.SHORT.equals(bnd.getName());
	}

	public static boolean isByte(ITypeBinding bnd) {
		if (!(bnd instanceof IPrimitiveTypeBinding))
			return false;
		return ISimpleType.BYTE.equals(bnd.getName());
	}

	public static boolean isChar(ITypeBinding bnd) {
		if (!(bnd instanceof IPrimitiveTypeBinding))
			return false;
		return ISimpleType.CHAR.equals(bnd.getName());
	}


}
