/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/util/NameTool.java#3 $
 */

package com.sap.tc.jtools.jlint.jom.util;

import java.lang.reflect.Modifier;

import com.sap.tc.jtools.jlint.jom.interfaces.IPackageBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.IReferenceTypeBinding;
import com.sap.tc.jtools.jlint.jom.interfaces.ITypeBinding;

/**
 * @author $Author: perforce $
 */
public class NameTool {

  private NameTool() {
  }

  /**
   * get the fully qualified class name of a binding in
   * dot-notation.
   * 
   * @param bnd the binding
   * @return the fully qualified class name
   */
  public static String getFullClassName(ITypeBinding bnd) {
    return bnd.getName();
  }

  /**
   * get the full package name of a binding in
   * dot-notation.
   * 
   * @param bnd the binding
   * @return the fully qualified package name
   */
  public static String getFullPackageName(IReferenceTypeBinding bnd) {
    IPackageBinding pkgBnd = bnd.getPackage();
    if (pkgBnd == null)
      return "";
    String[] comp = pkgBnd.getNameComponents();
    StringBuffer buf = new StringBuffer(comp.length);
    for (int i = 0; i < comp.length; i++) {
      buf.append(((i > 0) ? "." : "") + comp[i]);
    }
    return buf.toString();
  }

  /**
   * convert a String[] to a single String, elements 
   * separated by a dot "."
   */
  public static String toDotNotation(String[] components) {
    StringBuffer buf = new StringBuffer(components.length);
    for (int i = 0; i < components.length; i++) {
      buf.append(((i > 0) ? "." : "") + components[i]);
    }
    return buf.toString();
  }

  /**
   * convert a java.lang.reflect.Modifier int encoding
   * to human readable modifiers (e.g. "public static final").
   */
  public static String getHumanReadableModifiers(int modifiers) {
  	StringBuffer mods = new StringBuffer();
  	if (Modifier.isPublic(modifiers)) {
  		mods.append("public ");
  	}
  	if (Modifier.isPrivate(modifiers)) {
  		mods.append("private ");
  	}
  	if (Modifier.isProtected(modifiers)) {
  		mods.append("protected ");
  	}
  	if (Modifier.isStatic(modifiers)) {
  		mods.append("static ");
  	}
  	if (Modifier.isFinal(modifiers)) {
  		mods.append("final ");
  	}
  	if (Modifier.isSynchronized(modifiers)) {
  		mods.append("synchronized ");
  	}
  	if (Modifier.isAbstract(modifiers)) {
  		mods.append("abstract ");
  	}
  	if (Modifier.isNative(modifiers)) {
  		mods.append("native ");
  	}
  	if (Modifier.isTransient(modifiers)) {
  		mods.append("transient ");
  	}
  	if (Modifier.isVolatile(modifiers)) {
  		mods.append("volatile ");
  	}
  	if (Modifier.isStrict(modifiers)) {
  		mods.append("strictfp ");
  	}
  	return mods.toString();
  }

}
