/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/Traversable.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Interface implemented by all nodes that can be visited
 * by an instance of com.sap.tc.jtools.jlint.jom.interfaces.ITestVisitor.
 */
public interface Traversable extends Position{

  /**
   * node type integer constants
   */

  public static final int ANONYMOUS_CLASS_DECLARATION = 1;
  public static final int ARRAY_ACCESS = 2;
  public static final int ARRAY_CREATION = 3;
  public static final int ARRAY_INITIALIZER = 4;
  public static final int ARRAY_TYPE = 5;
  public static final int ASSERT_STATEMENT = 6;
  public static final int ASSIGNMENT = 7;
  public static final int BLOCK = 8;
  public static final int BOOLEAN_LITERAL = 9;
  public static final int BREAK_STATEMENT = 10;
  public static final int CAST_EXPRESSION = 11;
  public static final int CATCH_CLAUSE = 12;
  public static final int CHARACTER_LITERAL = 13;
  public static final int CLASS_INSTANCE_CREATION = 14;
  public static final int COMPILATION_UNIT = 15;
  public static final int CONDITIONAL_EXPRESSION = 16;
  public static final int CONSTRUCTOR_INVOCATION = 17;
  public static final int CONTINUE_STATEMENT = 18;
  public static final int DO_STATEMENT = 19;
  public static final int EMPTY_STATEMENT = 20;
  public static final int EXPRESSION_STATEMENT = 21;
  public static final int FIELD_ACCESS = 22;
  public static final int FIELD_DECLARATION = 23;
  public static final int FOR_STATEMENT = 24;
  public static final int IF_STATEMENT = 25;
  public static final int IMPORT_DECLARATION = 26;
  public static final int INFIX_EXPRESSION = 27;
  public static final int INSTANCEOF_EXPRESSION = 28;
  public static final int INITIALIZER = 29;
  public static final int LABELED_STATEMENT = 30;
  public static final int METHOD_DECLARATION = 31;
  public static final int METHOD_INVOCATION = 32;
  public static final int NULL_LITERAL = 33;
  public static final int NUMBER_LITERAL = 34;
  public static final int PACKAGE_DECLARATION = 35;
//  public static final int PARENTHESIZED_EXPRESSION = 36;
  public static final int POSTFIX_EXPRESSION = 37;
  public static final int PREFIX_EXPRESSION = 38;
  public static final int QUALIFIED_NAME = 39;
  public static final int RETURN_STATEMENT = 40;
  public static final int SIMPLE_NAME = 41;
  public static final int SIMPLE_TYPE = 42;
  public static final int STRING_LITERAL = 43;
  public static final int SUPER_CONSTRUCTOR_INVOCATION = 44;
  public static final int SUPER_EXPRESSION = 45;
  public static final int SUPER_METHOD_INVOCATION = 46;
  public static final int SWITCH_CASE = 47;
  public static final int SWITCH_STATEMENT = 48;
  public static final int SYNCHRONIZED_STATEMENT = 49;
  public static final int THIS_EXPRESSION = 50;
  public static final int THROW_STATEMENT = 51;
  public static final int TRY_STATEMENT = 52;
  public static final int TYPE_DECLARATION = 53;
  public static final int TYPE_DECLARATION_STATEMENT = 54;
  public static final int TYPE_LITERAL = 55;
  public static final int VARIABLE_DECLARATION = 56;
  public static final int VARIABLE_DECLARATION_STATEMENT = 57;
  public static final int WHILE_STATEMENT = 58;
  public static final int PACKAGE_NAME = 59;

  public void traverse(IVisitor visitor);
  /** returns the node type as an integer constant */
  public int getNodeType();

}
