/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/ITypeDeclarationStatement.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a type declaration statement (i.e. a statement inside type containing
 * a type declaration).
 * 
 * <p>
 * <code>
 *      type_declaration;
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li>  type declaration </li>
 * </ul>
 */

public interface ITypeDeclarationStatement extends IStatement {

	/**
	 * returns the type declaration.
	 * 
	 * @return type declaration
	 */ 
	public ITypeDeclaration getTypeDeclaration();
	
	/**
	 * returns the type binding.
	 * 
	 * @return type binding
	 */ 	
	public ITypeBinding resolveBinding();
}

