/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/ITypeDeclaration.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a type declaration.
 * 
 * <p>
 * <code>
 *     [modifiers] [class|interface] name [extends superclass] [implements superinterfaces] {
 *         body
 *     }
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li>  name </li>
 * <li> superclass </li>
 * <li> superinterfaces </li>
 * <li> body declarations </li>
 * </ul>
 */

public interface ITypeDeclaration extends IBodyDeclaration {

	/**
	 * returns whether the type is an interface.
	 * 
	 * @return <code>true</code> if the type is an interface
	 */  
	public boolean isInterface();
	
    /**
	 * returns the type modifiers.
	 * <p>
	 * Note that deprecated is not included among the modifiers.
	 * Use <code>isDeprecated</code> to find out whether a binding is deprecated.
	 * </p>
	 * 
	 * @return the bit-wise or of <code>Modifier</code> constants
	 */ 
	public int getModifiers();
	
	/**
	 * returns the type name.
	 * 
	 * @return type name
	 */ 
	public ISimpleName getName();
	
	/**
	 * returns the superclass name (or <code>null</code>).
	 * 
	 * @return superclass name
	 */ 	
	public IName getSuperclass() ; 
	
   /**
     * returns an array of super interfaces (type IName). If the 
     * type does not declare any, the method returns an empty array (not <code>null</code>).
     * 
     * @return array of super interfaces
     */		
	public IName[] getSuperInterfaces();

   /**
     * returns an array of body declarations. If the 
     * type does not contain any, the method returns an empty array (not <code>null</code>).
     * 
     * @return array of body declarations
     */	
	public IBodyDeclaration[] getBodyDeclarations();

	/**
	 * returns an array of field declarations.
	 * 
	 * @return field declarations
	 */  
	public IFieldDeclaration[] getFields(); 

	/**
	 * returns an array of method declarations.
	 * 
	 * @return method declarations
	 */  
	public IMethodDeclaration[] getMethods();

	/**
	 * returns an array of type declarations.
	 * 
	 * @return type declarations
	 */  
	public ITypeDeclaration[] getTypes();

	/**
	 * returns whether the type is a package member.
	 * 
	 * @return <code>true</code> if the type is a package member
	 */  
	public boolean isPackageMemberTypeDeclaration();

	/**
	 * returns whether the type is a type member.
	 * 
	 * @return <code>true</code> if the type is a type member
	 */  
	public boolean isMemberTypeDeclaration();

	/**
	 * returns whether the type is local.
	 * 
	 * @return <code>true</code> if the type is local
	 */  
	public boolean isLocalTypeDeclaration();
	
	/**
	 * returns the type binding.
	 * 
	 * @return type binding
	 */ 	
	public IReferenceTypeBinding resolveBinding();
	
	/**
	 * Returns the Javadoc documentation for this type
	 * 
	 * @return javadoc
	 * 
	 */			
	public IJavadoc getJavadoc();
}

