/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/ITypeBinding.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents the binding associated with a given type.
 */
public interface ITypeBinding extends IBinding {

	/**
	 * returns whether the type is the null type.
	 * 
	 * @return <code>true</code> if the type is the null type
	 */  
	public boolean isNullType();

	/**
	 * returns whether the type is primitive.
	 * 
	 * @return <code>true</code> if the type is primitive
	 */  
 	public boolean isPrimitive();
	
	/**
	 * returns whether the type is an array type.
	 * 
	 * @return <code>true</code> if the type is an array type
	 */  	
	public boolean isArray();
	
	/**
	 * returns whether the type is a reference (class or interface) type.
	 * 
	 * @return <code>true</code> if the type is a reference type
	 */  	
	public boolean isReference();
	
	
	 
}

