/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/ITryStatement.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

import java.util.List;

/**
 * Represents a  try statement.
 * 
 * Example:
 * <p>
 * <code>
 *     try {
 *         statements
 *     }  catch(type variable) {
 *         statements
 *     } finally {
 *         statements
 *     }
 * </code>
 * </p>  
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li>  block </li>
 * <li> catch clauses </li>
 * <li> finally block </li>
 * </ul>
 */
public interface ITryStatement extends IStatement {

	/**
     * returns the  statement body. 
     *  
     * @return body
     */	
	public IBlock getBody();

   /**
     * returns the list of catch clauses (each of which is an instance of ICatchClause). If the 
     * try statement does not contain any catch clause, the method returns an empty list 
     * (not <code>null</code>).
     * 
     * @return list of catch clauses
     */		
	public List catchClauses();
	
	/**
     * returns the  finally-block ( or <code>null</code>). 
     *  
     * @return finally-block
     */		
	public IBlock getFinally();
}
