/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/ITestVisitor.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Interface implemented by AST visitors.
 * 
 *  Visit methods may return <code>false</code> to interrrupt traversal
 */

public interface ITestVisitor  {
	
	/**
	 * internally used for pseudocomment handling
	 */
	public boolean isDisabledFor(Traversable node);
	
	public boolean visit(IAnonymousClassDeclaration node);
	public boolean visit(IArrayAccess node);
	public boolean visit(IArrayCreation node) ;
	public boolean visit(IArrayInitializer node);
	public boolean visit(IArrayType node);
	public boolean visit(IAssertStatement node);
	public boolean visit(IAssignment node);
	public boolean visit(IBlock node);
	public boolean visit(IBooleanLiteral node);
	public boolean visit(IBreakStatement node);
	public boolean visit(ICastExpression node);
	public boolean visit(ICatchClause node);
	public boolean visit(ICharacterLiteral node);
	public boolean visit(IClassInstanceCreation node);
	public boolean visit(ICompilationUnit node);
	public boolean visit(IConditionalExpression node);
	public boolean visit(IConstructorInvocation node);
	public boolean visit(IContinueStatement node);
	public boolean visit(IDoStatement node);
	public boolean visit(IEmptyStatement node);
	public boolean visit(IExpressionStatement node);
	public boolean visit(IFieldAccess node);
	public boolean visit(IFieldDeclaration node);
	public boolean visit(IForStatement node);
	public boolean visit(IIfStatement node);
	public boolean visit(IImportDeclaration node);
	public boolean visit(IInfixExpression node);
	public boolean visit(IInstanceofExpression node);
	public boolean visit(IInitializer node);
	public boolean visit(ILabeledStatement node);
	public boolean visit(IMethodDeclaration node);
	public boolean visit(IMethodInvocation node);
	public boolean visit(INullLiteral node);
	public boolean visit(INumberLiteral node);
	public boolean visit(IPackageDeclaration node);
	public boolean visit(IPostfixExpression node);
	public boolean visit(IPrefixExpression node); 
	public boolean visit(IQualifiedName node) ;
	public boolean visit(IReturnStatement node) ;
	public boolean visit(ISimpleName node) ;
	public boolean visit(ISimpleType node) ;
	public boolean visit(IStringLiteral node) ;
	public boolean visit(ISuperConstructorInvocation node) ;
	public boolean visit(ISuperExpression node) ;
	public boolean visit(ISuperMethodInvocation node) ;
	public boolean visit(ISwitchCase node) ;
	public boolean visit(ISwitchStatement node) ;
	public boolean visit(ISynchronizedStatement node) ; 
	public boolean visit(IThisExpression node) ; 
	public boolean visit(IThrowStatement node) ; 
	public boolean visit(ITryStatement node) ;
	public boolean visit(ITypeDeclaration node) ; 
	public boolean visit(ITypeDeclarationStatement node) ;	
	public boolean visit(ITypeLiteral node) ;
	public boolean visit(IVariableDeclaration node) ;
	public boolean visit(IVariableDeclarationStatement node) ;
	public boolean visit(IWhileStatement node);
	public boolean visit(IPackageName node);

	public void endVisit(IAnonymousClassDeclaration node) ;
	public void endVisit(IArrayAccess node) ;
	public void endVisit(IArrayCreation node) ;
	public void endVisit(IArrayInitializer node) ;
	public void endVisit(IArrayType node) ;
	public void endVisit(IAssertStatement node) ;	
	public void endVisit(IAssignment node) ;	
	public void endVisit(IBlock node) ;	
	public void endVisit(IBooleanLiteral node) ;
	public void endVisit(IBreakStatement node) ;
	public void endVisit(ICastExpression node) ;
	public void endVisit(ICatchClause node) ;
	public void endVisit(ICharacterLiteral node) ;
	public void endVisit(IClassInstanceCreation node) ;
	public void endVisit(ICompilationUnit node) ;
	public void endVisit(IConditionalExpression node) ;
	public void endVisit(IConstructorInvocation node) ;
	public void endVisit(IContinueStatement node) ;
	public void endVisit(IDoStatement node) ;
	public void endVisit(IEmptyStatement node) ;
	public void endVisit(IExpressionStatement node) ;
	public void endVisit(IFieldAccess node) ;
	public void endVisit(IFieldDeclaration node) ;
	public void endVisit(IForStatement node) ;
	public void endVisit(IIfStatement node) ;
	public void endVisit(IImportDeclaration node) ;
	public void endVisit(IInfixExpression node) ;
	public void endVisit(IInstanceofExpression node) ;
	public void endVisit(IInitializer node) ;
	public void endVisit(ILabeledStatement node) ;
	public void endVisit(IMethodDeclaration node) ;
	public void endVisit(IMethodInvocation node);
	public void endVisit(INullLiteral node);
	public void endVisit(INumberLiteral node) ;
	public void endVisit(IPackageDeclaration node);
	public void endVisit(IPostfixExpression node) ;
	public void endVisit(IPrefixExpression node) ;
	public void endVisit(IQualifiedName node) ;
	public void endVisit(IReturnStatement node) ;
	public void endVisit(ISimpleName node) ;
	public void endVisit(ISimpleType node) ;
	public void endVisit(IStringLiteral node) ;
	public void endVisit(ISuperConstructorInvocation node) ;
	public void endVisit(ISuperExpression node) ;
	public void endVisit(ISuperMethodInvocation node) ;
	public void endVisit(ISwitchCase node) ;
	public void endVisit(ISwitchStatement node) ;
	public void endVisit(ISynchronizedStatement node) ;
	public void endVisit(IThisExpression node) ;
	public void endVisit(IThrowStatement node) ;
	public void endVisit(ITryStatement node) ;
	public void endVisit(ITypeDeclaration node) ;
	public void endVisit(ITypeDeclarationStatement node) ;
	public void endVisit(ITypeLiteral node) ;
	public void endVisit(IVariableDeclaration node) ;
	public void endVisit(IVariableDeclarationStatement node) ;
	public void endVisit(IWhileStatement node) ;
	public void endVisit(IPackageName node) ;
}
