/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/ISwitchCase.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a switch case.
 * 
 * <p>
 * <code>
 *     case expression |default :  
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li>  expression </li>
 * </ul>
 */
public interface ISwitchCase extends IStatement {

	/**
     * returns the  case expression (or <code>null</code> if it is the default case). 
     *  
     * @return expression
     */	
	public IExpression getExpression();
	
	/**
     * returns <code>true</code> if it is the default case). 
     *  
     * @return <code>true</code> if it is the default case)
     */		
	public boolean isDefault();
}
