/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/ISuperMethodInvocation.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

import java.util.List;

/**
 * Represents the invocation of a method in the superclass.
 * 
 * <p>
 * <code>
 *     [Type.]super.method() ;
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> qualifier</li>
 * <li> arguments</li>
 * </ul>
 */
public interface ISuperMethodInvocation extends IExpression {

	/**
	 * returns the method name.
	 * 
	 * @return method name
	 */ 
	public String getName();
	
	/**
	 * returns the list of method arguments (each of which is an 
	 * instance of IExpression). In case of no arguments, the method 
	 * returns an empty list (not <code>null</code>).
	 * 
	 * @return list of method arguments
	 */	
	public List arguments();
    
    /**
     * returns the binding associated with the method
     * 
     * @return method binding
     */
    public IMethodBinding resolveMethodBinding();
    
	/**
	 * returns the prefix to the <code>super</code> token (or <code>null</code>)
	 * 
	 * @return prefix type
	 */
	public IType getQualifier();
}

