/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/ISuperExpression.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a  <code>super</code> reference.
 * 
 * <p>
 * <code>
 *     [Type.]super ;
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> qualifier</li>
 * </ul>
 */
public interface ISuperExpression extends IExpression {
	
	/**
	 * returns the prefix to the <code>super</code> token (or <code>null</code>)
	 * 
	 * @return prefix type
	 */
	public IType getQualifier();
}
