/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/ISuperConstructorInvocation.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a  super constructor invocation.
 * 
 * <p>
 * <code>
 *     expression.super(par_1,...par_n);
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> expression</li>
 * <li> arguments</li>
 * </ul>
 */

import java.util.List;

public interface ISuperConstructorInvocation extends IStatement {
 
 	/**
 	 * returns the prefix to the <code>super</code> token (or <code>null</code>)
 	 * 
 	 * @return prefix expression
 	 */
 	public IExpression getExpression();
 	
	/**
	 * returns the constructor arguments (instances of IExpression)
	 * 
	 * @return constructor arguments
	 */ 	
	public List arguments();
	
	/**
	 * returns the constructor binding
	 * 
	 * @return constructor binding
	 */
	public IMethodBinding resolveConstructorBinding();
}
