/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IStringLiteral.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents  a string literal.
 */
public interface IStringLiteral extends IExpression, Commentable {
	
	/**
	 * return the string value
	 * @return string value
	 */ 
	public String getLiteralValue();
	

	/**
	 * return the string value with special characters (\n etc.) escaped.
	 * @return escaped string value
	 */ 
	public String getEscapedValue();
}

