/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/ISimpleType.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a  simple type (i.e. one that is not an array).
 */ 
public interface ISimpleType extends IType {

	/** Type code for the primitive type "int". */
	public static final String INT = "int";//$NON-NLS-1$
	/** Type code for the primitive type "char". */
	public static final String CHAR =  "char";//$NON-NLS-1$
	/** Type code for the primitive type "boolean". */
	public static final String BOOLEAN =  "boolean";//$NON-NLS-1$
	/** Type code for the primitive type "short". */
	public static final String SHORT =  "short";//$NON-NLS-1$
	/** Type code for the primitive type "long". */
	public static final String LONG =  "long";//$NON-NLS-1$
	/** Type code for the primitive type "float". */
	public static final String FLOAT =  "float";//$NON-NLS-1$
	/** Type code for the primitive type "double". */
	public static final String DOUBLE =  "double";//$NON-NLS-1$
	/** Type code for the primitive type "byte". */
	public static final String BYTE =  "byte";//$NON-NLS-1$
	/** Type code for the primitive type "void".  */
	public static final String VOID = "void";//$NON-NLS-1$

	/**
	 * returns an array with the components of the full name.
	 * 
	 * Example java.lang.Object -> {"java","lang","Object"}
	 * 
	 * @return name components
	 */  	 
	public String[] getName();
}

