/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IReferenceTypeBinding.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents the binding of a reference type (class or interface, *not* array).
 */
public interface IReferenceTypeBinding extends ITypeBinding {

	public static final String ANONYMOUS_CLASS_NAME_PREFIX = "<"; //$NON-NLS-1$
	public static final String ANONYMOUS_CLASS_NAME_SUFFIX = ">"; //$NON-NLS-1$ 

	/**
	 * returns whether the binding represents a class
	 *  
	 * @return <code>true</code> if the binding represents a class
	 */
	public boolean isClass();

	/**
	 * returns whether the binding represents an interface
	 *  
	 * @return <code>true</code> if the binding represents an interface
	 */
	public boolean isInterface();

	/**
	 * returns the name of the class/interface
	 *  
	 * @return the name of the class/interface
	 */
	public String getIdentifier();	
	

	/**
	 * returns the package binding (or <code>null</code>).
	 *  
	 * @return package binding
	 */	
	public IPackageBinding getPackage();
	
	/**
	 * returns the declaring class (or <code>null</code>).
	 *  
	 * @return declaring class
	 */		
	public IReferenceTypeBinding getDeclaringClass();
	
	/**
	 * returns the superclass (or <code>null</code>).
	 *  
	 * @return superclass
	 */		
	public IReferenceTypeBinding getSuperclass();
	
	/**
	 * returns the implemented interfaces.
	 *  
	 * @return implemented interfaces
	 */		
 	public IReferenceTypeBinding[] getInterfaces();

	/**
	 * returns an integer representing the declared modifiers.
	 * 
	 * @see Modifier
	 *  
	 * @return declared modifiers
	 */		
	public int getDeclaredModifiers();
	
	/**
	 * returns <code>true</code> if the class/interface is declared at top level.
	 *  
	 * @return <code>true</code> if the class/interface is declared at top level.
	 */		
	public boolean isTopLevel();
	
	/**
	 * returns <code>true</code> if the class/interface is nested.
	 *  
	 * @return <code>true</code> if the class/interface is nested.
	 */		
	public boolean isNested();
	
	/**
	 * returns <code>true</code> if the class/interface is a member.
	 *  
	 * @return <code>true</code> if the class/interface is a member.
	 */		
	public boolean isMember();
	
	/**
	 * returns <code>true</code> if the class/interface is local.
	 *  
	 * @return <code>true</code> if the class/interface is local.
	 */		
	public boolean isLocal();
	
	/**
	 * returns <code>true</code> if the class is anonymous.
	 *  
	 * @return <code>true</code> if the class is anonymous.
	 */	
	public boolean isAnonymous();
	
	/**
	 * returns the bindings of the declared member types.
	 *  
	 * @return the bindings of the declared member types.
	 */	
	public IReferenceTypeBinding[] getDeclaredTypes();
	
	/**
	 * returns the bindings of the declared fields.
	 *  
	 * @return the bindings of the declared fields.
	 */		
	public IVariableBinding[] getDeclaredFields();
	
	/**
	 * returns the bindings of the declared methods.
	 *  
	 * @return the bindings of the declared methods.
	 */			
	public IMethodBinding[] getDeclaredMethods();
	
  /**
   * returns the bindings of all available methods.
   * (e.g. a default constructor is not declared, but available)
   *  
   * @return the bindings of all available methods.
   * @since 7.0
   */     
  public IMethodBinding[] getAvailableMethods();
  
	/**
	 * returns whether the binding has been obtained by parsing a source
	 *  
	 * @return <code>true</code> if the binding has been obtained by parsing a source
	 */	
	public boolean isFromSource();
	
	/**
	 * Returns the modifiers for this binding.
	 * <p>
	 * Note that deprecated is not included among the modifiers.
	 * Use <code>isDeprecated</code> to find out whether a binding is deprecated.
	 * </p>
	 * 
	 * @return the bit-wise or of <code>Modifier</code> constants
	 */ 
	public int getModifiers();

	/**
	 * Returns whether this binding is for something that is deprecated.
	 * A deprecated class, interface, field, method, or constructor is one that
	 * is marked with the 'deprecated' tag in its Javadoc comment.
	 *
	 * @return <code>true</code> if this binding is deprecated, and 
	 *    <code>false</code> otherwise
	 */
	public boolean isDeprecated();
}

