/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IPackageBinding.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a package binding.
 */
public interface IPackageBinding extends IBinding {

	/**
	 * returns the fully qualified, dot-separated (e.g."com.sap.mypkg")
   * package name (or <code>null</code> if unnamed).
	 * 
	 * @return name
	 */ 
	public String getName();
	
	/**
	 * returns whether the package is anonymous..
	 * 
	 * @return <code>true</code> if the package is anonymous.
	 */ 	
	public boolean isUnnamed();
	
	/**
	 * returns an array with the components of the package full name (or <code>null</code>).
	 * 
	 * Example com.sap.tc -> {"com","sap","tc"}
	 * 
	 * @return name components
	 */  
	public String[] getNameComponents(); 
}