/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IName.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents an expression of the form a.b.c...n.
 */
public interface IName extends IExpression, IQualifier {
	
	/**
	 * returns whether the expression is a simple name
	 * 
	 * @return <code>true</code> if the expression is a simple name
	 */
	public  boolean isSimpleName();
	
	/**
	 * returns whether the expression is a qualified name (i.e. of the form 
	 * <code>expression.a</code>)
	 * 
	 * @return <code>true</code> if the expression is a qualified name
	 */	
	public  boolean isQualifiedName();
	
	/**
	 * returns the binding associated with the expression
	 * 
	 * @return binding
	 */
	public   IBinding resolveBinding();
}
