/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IMethodDeclaration.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

 
import java.util.List;

/**
 * Represents a method declaration.
 * 
 * <p>
 * <code>
 *     [modifiers] [return_type] name (par_1,...,par_n) 
 *         [body]
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> return type </li>
 * <li> arguments </li>
 * <li> thrown exceptions </li>
 * <li> body </li>
 * </ul>
 */
 
public interface IMethodDeclaration extends IBodyDeclaration {

	/**
	 * returns whether the method is a  constructor.
	 * 
	 * @return <code>true</code> if the method is a  constructor
	 */  
	public boolean isConstructor();

	/**
	 * returns the field modifiers.
	 * <p>
	 * Note that deprecated is not included among the modifiers.
	 * Use <code>isDeprecated</code> to find out whether a binding is deprecated.
	 * </p>
	 * 
	 * @return the bit-wise or of <code>Modifier</code> constants
	 */ 
	public int getModifiers();
	
	/**
	 * returns the method name.
	 * 
	 * @return method names
	 */ 	
	public String getName();

   /**
     * returns the list of parameters (each of which is an instance of ISingleVariableDeclaration).
     * If no parameter is present the method returns an empty list (not <code>null</code>).
     * 
     * @return list of parameters
     */  
	public List parameters();

   /**
     * returns the list of exceptions (each of which is an instance of IName).
     * If no exception is present the method returns an empty list (not <code>null</code>).
     * 
     * @return list of exceptiions
     */  
	public List thrownExceptions();

	/**
	 * returns the return type.
	 * 
	 * @return return type
	 */ 
	public IType getReturnType();


	/**
	 * returns the method body ( or <code>null</code> if the method is abstract).
	 * 
	 * @return method body
	 */ 
	public IBlock getBody();
	
	
	/**
	 * returns the method binding ( or <code>null</code> if the binding cannot be computed).
	 * 
	 * @return method name
	 */ 	
	public IMethodBinding resolveBinding();
	
	/**
	 * Returns the Javadoc documentation for this method
	 * 
	 * @return javadoc
	 * 
	 */			
	public IJavadoc getJavadoc();
}

