/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IMethodBinding.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a method (or constructor) binding.
 */

public interface IMethodBinding extends IBinding {

	/**
	 * returns whether the binding refers to a constructor.
	 * 
	 * @return <code>true</code> if the binding refers to a constructor
	 */  
	public boolean isConstructor();

	/**
	 * returns the method name.
	 * If this is a constructor binding, returns <code>&lt;init&gt;</code>.
	 * @return method name
	 */  
	public String getName();
	
	/**
	 * returns the binding of the declaring class.
	 * 
	 * @return declaring class
	 */  	
	public IReferenceTypeBinding getDeclaringClass();
	
	/**
	 * returns an array with the parameter type bindings.
	 * 
	 * @return parameter types
	 */  		
	public ITypeBinding[] getParameterTypes();

	/**
	 * returns return-type binding.
	 * 
	 * @return return type
	 */ 	
	public ITypeBinding getReturnType();

	/**
	 * returns an array with the exception type bindings.
	 * 
	 * @return parameter types
	 */  
	public IReferenceTypeBinding[] getExceptionTypes();
	
	/**
	 * Returns the modifiers for this binding.
	 * <p>
	 * Note that deprecated is not included among the modifiers.
	 * Use <code>isDeprecated</code> to find out whether a binding is deprecated.
	 * </p>
	 * 
	 * @return the bit-wise or of <code>Modifier</code> constants
	 */ 
	public int getModifiers();

	/**
	 * Returns whether this binding is for something that is deprecated.
	 * A deprecated class, interface, field, method, or constructor is one that
	 * is marked with the 'deprecated' tag in its Javadoc comment.
	 *
	 * @return <code>true</code> if this binding is deprecated, and 
	 *    <code>false</code> otherwise
	 */
	public boolean isDeprecated();
}