/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/ILabeledStatement.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a labeled statement.
 * 
 * <p>
 * <code>
 *     label: statement
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> body </li>
 * </ul>
 * 
 */

public interface ILabeledStatement extends IStatement {

	/**
	 * returns the label.
	 * 
	 * @return label
	 */   
	public String getLabel();

	/**
	 * Returns the statement.
	 * 
	 * @return statement
	 */   
	public IStatement getBody();
}

