/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IInstanceofExpression.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents an instance-of expression.
 * 
 * 
 * <p>
 * <code>
 *      expression instanceof type
 * </code>
 * </p>  
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> left operand </li>
 * <li> right operand </li>
 * </ul>
 */
public interface IInstanceofExpression extends IExpression {
	/**
	 * Returns the left operand expression.
	 * 
	 * @return left operand
	 */ 
  	public IExpression getLeftOperand();
  	
	/**
	 * Returns the right operand (i.e. the type).
	 * 
	 * @return right operand
	 */   	
  	public IType getRightOperand();
}
