/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IInitializer.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents an initializer.
 * 
 * 
 * <p>
 * <code>
 *     [static] {
 *         stmt_1;
 *         ...
 *         stmt_n
 *     }
 * </code>
 * </p>  
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> body </li>
 * </ul>
 * 
 * Copyright (c) 2003, SAP AG
 * 
 */

public interface IInitializer extends IBodyDeclaration {
	/**
	 * Returns the initializer modifiers.
	 * 
	 * @return the bit-wise or of <code>Modifier</code> constants
	 */ 
 	public int getModifiers();

	/**
	 * Returns the initializer body.
	 * 
	 * @return initializer body
	 */ 
	public IBlock getBody();
}

