/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IInfixExpression.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents an  infix expression.
 * 
 * 
 * <p>
 * <code>
 *     leftHandSideExpression op rightHandSideExpression  
 * </code>
 * </p>  
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> left operand </li>
 * <li> right operand </li>
 * </ul>
 */

public interface IInfixExpression extends IExpression {

	/** Multiplication "*" operator. */
	public static final String TIMES = "*"; //$NON-NLS-1$
	/** Division "/" operator. */
	public static final String DIVIDE = "/"; //$NON-NLS-1$
	/** Remainder "%" operator. */
	public static final String REMAINDER = "%"; //$NON-NLS-1$
	/** Addition (or string concatenation) "+" operator. */
	public static final String PLUS = "+"; //$NON-NLS-1$
	/** Subtraction "-" operator. */
	public static final String MINUS = "-"; //$NON-NLS-1$
	/** Left shift "&lt;&lt;" operator. */
	public static final String LEFT_SHIFT = "<<"; //$NON-NLS-1$
	/** Signed right shift "&gt;&gt;" operator. */
	public static final String RIGHT_SHIFT_SIGNED = ">>"; //$NON-NLS-1$
	/** Unsigned right shift "&gt;&gt;&gt;" operator. */
	public static final String RIGHT_SHIFT_UNSIGNED = ">>>"; //$NON-NLS-1$
	/** Less than "&lt;" operator. */
	public static final String LESS = "<"; //$NON-NLS-1$
	/** Greater than "&gt;" operator. */
	public static final String GREATER = ">"; //$NON-NLS-1$
	/** Less than or equals "&lt;=" operator. */
	public static final String LESS_EQUALS = "<="; //$NON-NLS-1$
	/** Greater than or equals "&gt=;" operator. */
	public static final String GREATER_EQUALS = ">="; //$NON-NLS-1$
	/** Equals "==" operator. */
	public static final String EQUALS = "=="; //$NON-NLS-1$
	/** Not equals "!=" operator. */
	public static final String NOT_EQUALS = "!="; //$NON-NLS-1$
	/** Exclusive OR "^" operator. */
	public static final String XOR = "^"; //$NON-NLS-1$
	/** Inclusive OR "|" operator. */
	public static final String OR = "|"; //$NON-NLS-1$
	/** AND "&amp;" operator. */
	public static final String AND = "&"; //$NON-NLS-1$
	/** Conditional OR "||" operator. */
	public static final String CONDITIONAL_OR = "||"; //$NON-NLS-1$
	/** Conditional AND "&amp;&amp;" operator. */
	public static final String CONDITIONAL_AND = "&&"; //$NON-NLS-1$

	/**
	  * returns the operator string
	  * 
	  * @return operator string
	  */
	public String getOperator();

	/**
	  * returns the left hand side expression
	  * 
	  * @return left hand side expression
	  */
	public IExpression getLeftOperand();

	/**
	  * returns the right hand side expression
	  * 
	  * @return right hand side expression
	  */
	public IExpression getRightOperand();

}
