/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IImportDeclaration.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents an import declaration.
 * 
 * <p>
 * <code>
 *     import package.*;
 * </code>
 * or 
 * <code>
 *     import package.class;
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li>  name </li>
 * </ul>
 */
public interface IImportDeclaration  extends Position, Traversable {

   /**
     * returns the package name components.
     * 
     * @return package name components
     */
	public String[] getName();
	
   /**
     * returns <code>true</code> if the declaration is of the form <code>import package.*;</code>.
     * 
     * 
     * @return <code>true</code> if the declaration is of the form <code>import package.*;</code>.
     */	
	public boolean isOnDemand();
	
   /**
     * returns the import (package or type) binding.
     * 
     * @return import binding.
     */		
	public IBinding resolveBinding();
}

