/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IIfStatement.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents an if-statement.
 * 
 * <p>
 * <code>
 *     if (condition)
 *         then_statement
 *     [else
 *         else_statement]
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> expression </li>
 * <li> then-statement </li>
 * <li> else-statement </li>
 * </ul>
 * 
 */


public interface IIfStatement extends IStatement {

   /**
     * returns the condition expression.
     * 
     * @return condition
     */
	public IExpression getExpression();

   /**
     * returns the then-statement.
     * 
     * @return then-statement
     */
	public IStatement getThenStatement();
	
   /**
     * returns the else-statement (or <code>null</code>).
     * 
     * @return else-statement
     */	
	public IStatement getElseStatement();
}

