/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IForStatement.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a for statement.
 * 
 * <p>
 * <code>
 *     for ( initializers;expression;updaters)
 *         statement
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> initializers </li>
 * <li> condition </li>
 * <li> updaters </li>
 * <li> body </li>
 * </ul>
 * 
 */


public interface IForStatement extends IStatement {
   /**
     * returns an array of initializers.
     * 
     * If no initializer is present the method returns an empty array (not <code>null</code>).
     * 
     * @return array of initializers
     */  
	public IStatement[] getInitializers();

   /**
     * returns the condition expression.
     * 
     * @return condition expression
     */ 
	public IExpression getExpression();

   /**
     * returns an array of updaters.
     * If no updaterer is present the method returns an empty array (not <code>null</code>).
     * 
     * @return array of updaters
     */  
	public IExpression[] getUpdaters();
	
   /**
     * returns the body.
     * 
     * @return body
     */ 	
	public IStatement getBody();
}
