/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IFieldDeclaration.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a field declaration.
 * 
 * <p>
 * <code>
 *     [modifiers] type fragment_1,...,fragment_n;
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li>  type </li>
 * <li>  fragments </li>
 * </ul>
 * 
 */

public interface IFieldDeclaration extends IBodyDeclaration {
	/**
	 * Returns the field modifiers.
	 * <p>
	 * Note that deprecated is not included among the modifiers.
	 * Use <code>isDeprecated</code> to find out whether a binding is deprecated.
	 * </p>
	 * 
	 * @return the bit-wise or of <code>Modifier</code> constants
	 */
	public int getModifiers();

	/**
	 * Returns the field type.
	 * 
	 * @return field type
	 */
	public IType getType();

	/**
	 * returns the  variable name. 
	 *  
	 * @return name
	 */	
	public  String getName();

	/**
	 * returns the  initializer (if present, otherwise <code>null</code>). 
	 *  
	 * @return initializer
	 */	
	public  IExpression getInitializer();

	/**
	 * returns the  variable binding. 
	 *  
	 * @return variable binding
	 */	
	public IVariableBinding resolveBinding();
	
	/**
	 * Returns the Javadoc documentation for this field
	 * 
	 * @return javadoc
	 * 
	 */		
	public IJavadoc getJavadoc();
}
