/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IExpression.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents an expression. 
 * 
 * This interface is not implemented directly, but only through its subinterfaces:
 * 
 * 
 * <p>
 * <code>IArrayAccess</code>
 * </p>
 * <p>
 * <code>IArrayCreation</code>
 * </p>
 * <p>
 * <code>IArrayInitializer</code>
 * </p>
 * <p>
 * <code>IAssignment</code>
 * </p>
 * <p>
 * <code>IBooleanLiteral</code>
 * </p>
 * <p>
 * <code>ICastExpression</code>
 * </p>
 * <p>
 * <code>ICharacterLiteral</code>
 * </p>
 * <p>
 * <code>IClassInstanceCreation</code>
 * </p>
 * <p>
 * <code>IConditionalExpression</code>
 * </p>
 * <p>
 * <code>IFieldAccess</code>
 * </p>
 * <p>
 * <code>IInfixExpression</code>
 * </p>
 * <p>
 * <code>IInstanceofExpression</code>
 * </p>
 * <p>
 * <code>IMethodInvocation</code>
 * </p>
 * <p>
 * <code>IQualifiedName</code>
 * </p>
 * <p>
 * <code>ISimpleName</code>
 * </p>
 * <p>
 * <code>INullLiteral</code>
 * </p>
 * <p>
 * <code>INumberLiteral</code>
 * </p>
 * <p>
 * <code>IParenthesizedExpression</code>
 * </p>
 * <p>
 * <code>IPostfixAccess</code>
 * </p>
 * <p>
 * <code>IPrefixExpression</code>
 * </p>
 * <p>
 * <code>IStringLiteral</code>
 * </p>
 * <p>
 * <code>ISuperFieldAccess</code>
 * </p>
 * <p>
 * <code>ISuperMethodInvocation</code>
 * </p>
 * <p>
 * <code>IThisExpression</code>
 * </p>
 * <p>
 * <code>ITypeLiteral</code>
 * </p>
 * <p>
 * <code>IVariableDeclarationExpression</code>
 * </p>
 * 
 */
public interface IExpression  extends Position, Traversable {

   /**
     * returns the expression's type binding (or <code>null</code> if the binding cannot be computed)
     * 
     * @return type binding
     */		
	public ITypeBinding resolveTypeBinding();
}

