/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IDoStatement.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

/**
 * Represents a do statement.
 * 
 * <p>
 * <code>
 *     do statement while(condition);
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li>  expression </li>
 * <li>  body </li>
 * </ul>
 * 
 */

public interface IDoStatement extends IStatement {
	
   /**
     * returns the condition expression;
     * 
     * @return condition
     */	
	public IExpression getExpression();

   /**
     * returns the body statement;
     * 
     * @return body
     */	
	public IStatement getBody();
}
