/*
 * Copyright (c) 2004 by SAP AG, Walldorf.,
 * http://www.sap.com
 * All rights reserved.
 *
 * This software is the confidential and proprietary information
 * of SAP AG, Walldorf. You shall not disclose such Confidential
 * Information and shall use it only in accordance with the terms
 * of the license agreement you entered into with SAP.
 * 
 * $Id: //tc/jtools/630_VAL_REL/src/_jlint/java/_modules/_jom/_core/src/com/sap/tc/jtools/jlint/jom/interfaces/IConstructorInvocation.java#2 $
 */

package com.sap.tc.jtools.jlint.jom.interfaces;

import java.util.List;

/**
 * Represents a constructor invocation.
 * 
 * <p>
 * <code>
 *     this(par_1,...par_n);
 * </code>
 * </p>
 * 
 * <p>
 * Traversal algorithm:
 * <ul>
 * <li> arguments</li>
 * </ul>
 * 
 */

public interface IConstructorInvocation extends IStatement {

   /**
     * returns the list of constructor arguments (each of which is an 
     * instance of IExpression). In case of no arguments, the method 
     * returns an empty list (not <code>null</code>).
     * 
     * @return list of constructor arguments
     */
	public List arguments();

   /**
     * returns the constructor binding (or <code>null</code> if the binding
     * cannot be computed)
     * 
     * @return constructor binding
     */
	public IMethodBinding resolveConstructorBinding();
}

